<!-- A majority of the work designers do will be on themes in the (Now) Next 1-3 milestone column. These themes are comprised of high-confidence outcomes and validated needs. The UX theme issue is where collaboration should occur, including plans and discussion on subthemes, research, and design feedback. Related issues for design exploration and solution validation should stem from the theme issue. 

One of the advantages of working with UX themes is that it allows us to think and design holistically by designing the theme as a whole as opposed to a single issue at a time trying to piece them together as you go. For more details please refer to this section of the handbook when creating UX Themes: https://about.gitlab.com/handbook/product/ux/product-design/ux-roadmaps/#theme-structure -->

### UX Theme 
<!-- A theme is written as a statement that combines the beneficiary, their need, and the expected outcome when the work is delivered. Well-defined statements are concise without sacrificing the substance of the theme so that anyone can understand it at a glance. (For instance; Reduce the effort for security teams to identify and escalate business-critical risks) 

!!Note: The theme statement is the defacto title that will be used to reference the theme and serve as the theme issue title.!!
-->

----

### Problem to solve
<!-- In a brief statement, summerize the problem we are intending to address with this theme. For instance, users are unable to complete [task], or, users struggle with the amount of steps required to complete [task] -->


### Beneficiary 
<!-- Who is the recipient(s) of the value this theme provides; a customer, end-user, or buyer. Who benefits from this theme being executed? This can be a role, a team, or a persona. For instance: "Development teams, [or] Developers, [or], Sasha the Software Engineer". --> 

- **[Direct beneficiary]**

#### Need & Primary JTBD
<!-- What is the JTBD and what are the needs related to the beneficiary and theme? 
- JTBD = The JTBD statement, for instance, (When I am triaging vulns, I want to address business-critical risks, So I can ensure there is no unattended risk in my orgs assets.) 
- Need = Abstracted from the JTBD, for instance, (Identify and escalate business-critical risks detected in my orgs assets.)
--> 

- **JTBD:** 
- **Need:**   

#### Expected outcome
<!-- What will the user be able to achieve when this theme is executed? For instance, (Users will be able to effectively triage vulnerabilities at scale across all their orgs assets.) -->


#### Business objective
<!-- What business objective will result from delivering this theme? This answers why we are working on this theme from a business perspective. Examples of objectives are but are not limited to: Sales rate / conversion rate, Success rate / completion rate, Traffic / visitor count, Engagement, or other business-oriented goals. --> 


#### Confidence
<!-- How well do we understand the user's problem and their need? Refer to https://about.gitlab.com/handbook/product/ux/product-design/ux-roadmaps/#confidence to assess confidence -->


| Confidence | Research | 
| --- | --- | 
| [High/Medium/Low] | [research/insight issue](Link) |


### Subthemes & Requirements
<!-- Subthemes are more granular validated needs, goals, and additional details that the theme encompasses. These are typically reserved for themes in the next (1-3 milestones) column. Subthemes may also consist of existing feature or design issues that exist in GitLab and directly relate to the theme. Subthemes answer “how” we are going to solve the user need while the theme itself answers “what” the need is and “who” will be benefiting from the solution.

Note: This is not a backlog. If the subthemes can not be delivered in the theme timeframe then the theme is too big and needs to be broken down into multiple themes. -->

#### Feature/solution subthemes
<!-- Use this table to track feature issues related to this theme (if applicable). Not all themes require subthemes as subthemes are typically discovered while working on the theme itself. Think of subthemes as if they were the result of design breaking down the issue into discrete work items. 

Note: if feature issues already exist then you can add them to this table. Keep in mind that subthemes require validation if they are assumptive 

Refer to https://about.gitlab.com/handbook/product/ux/product-designer/#ux-issue-weights for calculating UX weights.
--> 

| Issue | UX Weight |  
| ---------- | --------- | 
| [Issue](link) | `0 - 10` | 
| [Issue](link) | `0 - 10` | 
| [Issue](link) | `0 - 10` | 

#### Research subthemes
<!-- Use this table to track UX research related to this theme. This may include, problem validation and/or solution validation activities. 
--> 

| Issue | Research type | Research status |
| ---------- | --------- | --------- |   
| [Issue]()  | <!--Solution validation, Problem validation, etc., --> |  <!-- Planned, In Progress, Complete, etc.,-->  |  
| [Issue]()  | <!--Solution validation, Problem validation, etc., --> |  <!-- Planned, In Progress, Complete, etc.,-->  |


/label ~"UX"  ~"UX Theme"
